﻿using System;
using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Map Patient Veteran to Proxy Add Request Enterprise Component.
    /// </summary>
    public class MapPatientVeteranIdentifierToProxyAddRequestEcStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (string.IsNullOrEmpty(state.PatientSite) || state.PatientSideIdentifierToAdd == null || state.Veteran == null) return;

            state.ProxyAddToVistaRequest = new ProxyAddMapper(state, true).Map();

            state.SerializedInstance = string.Format("Patient {0},{1}", Environment.NewLine, PipelineUtilities.SerializeInstance(state.ProxyAddToVistaRequest));
        }
    }
}